const chatsData=[{id:1,name:'Sarah Johnson',avatar:'SJ',lastMessage:'Hey! Did you see the latest updates?',time:'5m',unread:3,pinned:true,online:true,status:'online',phone:'+1 234 567 8901'},{id:2,name:'Michael Chen',avatar:'MC',lastMessage:'The meeting has been rescheduled to 3 PM',time:'12m',unread:0,pinned:true,online:false,status:'last seen 2 hours ago',phone:'+1 234 567 8902'},{id:3,name:'Emma Williams',avatar:'EW',lastMessage:'Thanks for your help! Really appreciate it 😊',time:'1h',unread:1,pinned:false,online:true,status:'online',phone:'+1 234 567 8903'},{id:4,name:'David Martinez',avatar:'DM',lastMessage:'Can you send me those files?',time:'2h',unread:0,pinned:false,online:false,status:'last seen 1 hour ago',phone:'+1 234 567 8904'},{id:5,name:'Lisa Anderson',avatar:'LA',lastMessage:'Perfect! See you tomorrow at 10',time:'3h',unread:0,pinned:false,online:false,status:'last seen yesterday',phone:'+1 234 567 8905'},{id:6,name:'James Wilson',avatar:'JW',lastMessage:'I\'ll check and get back to you',time:'Yesterday',unread:2,pinned:false,online:false,status:'last seen yesterday',phone:'+1 234 567 8906'},{id:7,name:'Sophia Brown',avatar:'SB',lastMessage:'That sounds like a great idea!',time:'Yesterday',unread:0,pinned:false,online:true,status:'online',phone:'+1 234 567 8907'},{id:8,name:'Robert Taylor',avatar:'RT',lastMessage:'Let me know when you\'re free',time:'Yesterday',unread:0,pinned:false,online:false,status:'last seen today at 9:30 AM',phone:'+1 234 567 8908'},{id:9,name:'Olivia Davis',avatar:'OD',lastMessage:'I sent you an email with all the details',time:'2 days ago',unread:1,pinned:false,online:false,status:'last seen 2 days ago',phone:'+1 234 567 8909'},{id:10,name:'William Garcia',avatar:'WG',lastMessage:'Awesome work on the presentation!',time:'2 days ago',unread:0,pinned:false,online:false,status:'last seen today at 11:15 AM',phone:'+1 234 567 8910'},{id:11,name:'Ava Rodriguez',avatar:'AR',lastMessage:'Can we schedule a call for next week?',time:'3 days ago',unread:0,pinned:false,online:true,status:'online',phone:'+1 234 567 8911'},{id:12,name:'Daniel Lee',avatar:'DL',lastMessage:'Got it, thanks!',time:'3 days ago',unread:0,pinned:false,online:false,status:'last seen 3 days ago',phone:'+1 234 567 8912'},{id:13,name:'Mia Martinez',avatar:'MM',lastMessage:'Looking forward to it!',time:'4 days ago',unread:0,pinned:false,online:false,status:'last seen yesterday',phone:'+1 234 567 8913'},{id:14,name:'Christopher White',avatar:'CW',lastMessage:'I\'ll review and send feedback',time:'5 days ago',unread:0,pinned:false,online:false,status:'last seen 4 days ago',phone:'+1 234 567 8914'},{id:15,name:'Isabella Harris',avatar:'IH',lastMessage:'Sounds good to me!',time:'1 week ago',unread:0,pinned:false,online:false,status:'last seen 5 days ago',phone:'+1 234 567 8915'}];const groupsData=[{id:101,name:'Team Alpha',avatar:'TA',lastMessage:'Alex: Great job everyone! 🎉',time:'10m',members:12,unread:5},{id:102,name:'Family Group',avatar:'FG',lastMessage:'Mom: Dinner at 7 PM tonight',time:'1h',members:8,unread:2},{id:103,name:'Project Phoenix',avatar:'PP',lastMessage:'Jordan: Updated the timeline',time:'2h',members:15,unread:0},{id:104,name:'Book Club',avatar:'BC',lastMessage:'Sarah: Which book should we read next?',time:'5h',members:6,unread:8},{id:105,name:'Gym Buddies',avatar:'GB',lastMessage:'Mike: Tomorrow at 6 AM?',time:'Yesterday',members:4,unread:0},{id:106,name:'Dev Team',avatar:'DT',lastMessage:'Lisa: Code review needed',time:'Yesterday',members:20,unread:3},{id:107,name:'Weekend Warriors',avatar:'WW',lastMessage:'Tom: Hiking this Saturday!',time:'2 days ago',members:9,unread:0},{id:108,name:'Coffee Lovers',avatar:'CL',lastMessage:'Emma: New cafe opened downtown',time:'3 days ago',members:7,unread:1}];const messagesData={1:[{id:1,type:'incoming',text:'Hey! How are you doing?',time:'10:30 AM',status:'seen'},{id:2,type:'outgoing',text:'I\'m doing great! Thanks for asking 😊',time:'10:32 AM',status:'seen'},{id:3,type:'incoming',text:'That\'s awesome! I wanted to ask you about the project',time:'10:33 AM',status:'seen'},{id:4,type:'outgoing',text:'Sure, what do you need to know?',time:'10:35 AM',status:'seen'},{id:5,type:'incoming',text:'Hey! Did you see the latest updates?',time:'10:55 AM',status:'delivered'}],2:[{id:1,type:'incoming',text:'Good morning!',time:'9:00 AM',status:'seen'},{id:2,type:'outgoing',text:'Good morning! How can I help you?',time:'9:05 AM',status:'seen'},{id:3,type:'incoming',text:'The meeting has been rescheduled to 3 PM',time:'9:48 AM',status:'delivered'}],3:[{id:1,type:'outgoing',text:'Let me know if you need any help',time:'8:30 AM',status:'seen'},{id:2,type:'incoming',text:'Thanks for your help! Really appreciate it 😊',time:'10:00 AM',status:'delivered'}]};function showToast(e,t=3e3){const s=document.getElementById("toast");s&&s.remove();const a=document.createElement("div");a.id="toast",a.className="fixed top-20 left-1/2 -translate-x-1/2 gradient-bg text-white px-6 py-3 rounded-2xl shadow-2xl z-50 animate-fade-in",a.textContent=e,document.body.appendChild(a),setTimeout(()=>{a.style.opacity="0",a.style.transform="translate(-50%, -20px)",a.style.transition="all 0.3s ease",setTimeout(()=>a.remove(),300)},t)}function getUrlParameter(e){return(new URLSearchParams(window.location.search)).get(e)}function initDarkMode(){const e=document.getElementById("darkModeToggle");if(!e)return;const t="true"===localStorage.getItem("darkMode");t&&(document.body.classList.add("dark"),updateDarkModeIcon(!0)),e.addEventListener("click",()=>{const e=document.body.classList.toggle("dark");localStorage.setItem("darkMode",e),updateDarkModeIcon(e),showToast(e?"Dark mode enabled":"Light mode enabled")})}function updateDarkModeIcon(e){const t=document.getElementById("darkModeIcon");t&&(t.innerHTML=e?'<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z"/>':`<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z"/>`)}function initInbox(){renderChatList(),initSearch(),initContextMenu(),applyDarkMode()}function renderChatList(e=""){const t=document.getElementById("chatList");if(!t)return;const s=[...chatsData].sort((e,t)=>e.pinned&&!t.pinned?-1:!e.pinned&&t.pinned?1:0),a=e?s.filter(t=>t.name.toLowerCase().includes(e.toLowerCase())||t.lastMessage.toLowerCase().includes(e.toLowerCase())):s;t.innerHTML=a.map(e=>`<div class="chat-item relative flex items-center gap-3 p-4 hover:bg-gray-50 cursor-pointer transition-all duration-200 border-b border-gray-100" data-chat-id="${e.id}" onclick="window.location.href='chat.html?user=${e.id}'" oncontextmenu="showContextMenu(event, ${e.id})"><div class="w-12 h-12 rounded-full gradient-bg flex items-center justify-center text-white font-semibold flex-shrink-0">${e.avatar}</div><div class="flex-1 min-w-0"><div class="flex items-center justify-between mb-1"><h3 class="font-semibold text-gray-900 truncate flex items-center gap-2">${e.name}${e.pinned?'<svg class="w-4 h-4 text-gray-400 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20"><path d="M5 5a2 2 0 012-2h6a2 2 0 012 2v14l-5-2.5L5 19V5z"/></svg>':""}</h3><span class="text-xs text-gray-500 flex-shrink-0">${e.time}</span></div><div class="flex items-center justify-between gap-2"><p class="text-sm text-gray-600 truncate flex-1">${e.lastMessage}</p><div class="flex items-center gap-2 flex-shrink-0">${e.unread>0?`<span class="gradient-bg text-white text-xs font-semibold px-2 py-0.5 rounded-full min-w-[20px] text-center">${e.unread}</span>`:""}${0===e.unread?'<svg class="w-4 h-4 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>':""}</div></div></div></div>`).join("")}function initSearch(){const e=document.getElementById("searchInput"),t=document.getElementById("clearSearch");e&&(e.addEventListener("input",e=>{const s=e.target.value;t.classList.toggle("hidden",!s),renderChatList(s)}),t.addEventListener("click",()=>{e.value="",t.classList.add("hidden"),renderChatList()}))}function initContextMenu(){const e=document.getElementById("contextMenu");if(!e)return;let t=null;window.showContextMenu=(s,a)=>{s.preventDefault(),s.stopPropagation(),t=a,e.style.left=`${s.pageX}px`,e.style.top=`${s.pageY}px`,e.classList.remove("hidden")},document.addEventListener("click",()=>{e.classList.add("hidden")}),e.querySelectorAll(".context-menu-item").forEach(e=>{e.addEventListener("click",e=>{const s=e.currentTarget.dataset.action,a=chatsData.find(e=>e.id===t);if(!a)return;switch(s){case"pin":a.pinned=!a.pinned,showToast(a.pinned?"Chat pinned":"Chat unpinned"),renderChatList();break;case"archive":showToast("Chat archived");break;case"mute":showToast("Chat muted");break;case"markread":a.unread=0,showToast("Marked as read"),renderChatList();break;case"delete":showToast("Chat deleted")}})})}function initChat(){const e=parseInt(getUrlParameter("user"))||1,t=chatsData.find(t=>t.id===e);t?(document.getElementById("chatName").textContent=t.name,document.getElementById("chatStatus").textContent=t.status,document.getElementById("chatAvatar").textContent=t.avatar,loadMessages(e),initMessageInput(e),initScrollToBottom(),initChatMenu(),applyDarkMode()):window.location.href="inbox.html"}function loadMessages(e){const t=document.getElementById("messagesArea"),s=messagesData[e]||[];let a='<div class="flex justify-center my-4"><span class="bg-gray-200 text-gray-600 text-xs px-3 py-1 rounded-full">Today</span></div>';s.forEach(e=>{if("incoming"===e.type)a+=`<div class="flex justify-start"><div class="message-bubble bg-white rounded-2xl rounded-tl-sm px-4 py-2 shadow-sm"><p class="text-gray-900 text-sm">${e.text}</p><span class="text-xs text-gray-500 mt-1 block">${e.time}</span></div></div>`;else{const t=getStatusIcon(e.status);a+=`<div class="flex justify-end"><div class="message-bubble gradient-bg rounded-2xl rounded-tr-sm px-4 py-2 shadow-sm"><p class="text-white text-sm">${e.text}</p><div class="flex items-center justify-end gap-1 mt-1"><span class="text-xs text-white text-opacity-90">${e.time}</span>${t}</div></div></div>`}}),t.innerHTML=a,scrollToBottom(!0)}function getStatusIcon(e){switch(e){case"sent":return'<svg class="w-4 h-4 text-white text-opacity-90" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>';case"delivered":return'<svg class="w-4 h-4 text-white text-opacity-90" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 13l4 4L23 7"/></svg>';case"seen":return'<svg class="w-4 h-4 text-blue-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 13l4 4L23 7"/></svg>';default:return""}}let typingTimeout=null;function initMessageInput(e){const t=document.getElementById("messageInput"),s=document.getElementById("sendBtn"),a=document.getElementById("micBtn"),n=document.getElementById("chatStatus"),i=chatsData.find(t=>t.id===e);t.addEventListener("input",()=>{t.style.height="auto",t.style.height=Math.min(t.scrollHeight,128)+"px";const e=t.value.trim().length>0;e?(s.classList.remove("opacity-50","pointer-events-none","hidden"),a.classList.add("hidden"),n.textContent="typing...",clearTimeout(typingTimeout),typingTimeout=setTimeout(()=>{n.textContent=i.status},1200)):(s.classList.add("opacity-50","pointer-events-none","hidden"),a.classList.remove("hidden"))});const o=()=>{const n=t.value.trim();if(!n)return;const i=new Date,o=i.toLocaleTimeString("en-US",{hour:"numeric",minute:"2-digit",hour12:!0});messagesData[e]||(messagesData[e]=[]);const r={id:Date.now(),type:"outgoing",text:n,time:o,status:"sent"};messagesData[e].push(r);const d=document.getElementById("messagesArea");d.insertAdjacentHTML("beforeend",`<div class="flex justify-end"><div class="message-bubble gradient-bg rounded-2xl rounded-tr-sm px-4 py-2 shadow-sm"><p class="text-white text-sm">${n}</p><div class="flex items-center justify-end gap-1 mt-1"><span class="text-xs text-white text-opacity-90">${o}</span>${getStatusIcon("sent")}</div></div></div>`),t.value="",t.style.height="auto",s.classList.add("opacity-50","pointer-events-none","hidden"),a.classList.remove("hidden"),scrollToBottom(),setTimeout(()=>{r.status="delivered",loadMessages(e)},1e3),setTimeout(()=>{r.status="seen",loadMessages(e)},2e3)};s.addEventListener("click",o),t.addEventListener("keydown",e=>{"Enter"!==e.key||e.shiftKey||(e.preventDefault(),o())}),a.addEventListener("click",()=>{showToast("Voice message coming soon")})}function initScrollToBottom(){const e=document.getElementById("messagesArea"),t=document.getElementById("scrollToBottom");e.addEventListener("scroll",()=>{const s=e.scrollHeight-e.scrollTop-e.clientHeight<100;t.classList.toggle("hidden",s)}),t.addEventListener("click",()=>{scrollToBottom()})}function scrollToBottom(e=!1){const t=document.getElementById("messagesArea");t.scrollTo({top:t.scrollHeight,behavior:e?"auto":"smooth"})}function initChatMenu(){const e=document.getElementById("chatMenuBtn"),t=document.getElementById("chatMenuDropdown");e.addEventListener("click",e=>{e.stopPropagation(),t.classList.toggle("hidden")}),document.addEventListener("click",()=>{t.classList.add("hidden")}),t.addEventListener("click",e=>{e.stopPropagation();const s=e.target.textContent.trim();showToast(`${s} coming soon`),t.classList.add("hidden")})}function initGroups(){renderGroupsList(),applyDarkMode()}function renderGroupsList(){const e=document.getElementById("groupsList");e&&(e.innerHTML=groupsData.map(e=>`<div class="group-item relative flex items-center gap-3 p-4 hover:bg-gray-50 cursor-pointer transition-all duration-200 border-b border-gray-100" onclick="showToast('Group chat coming soon')"><div class="w-12 h-12 rounded-full gradient-bg flex items-center justify-center text-white font-semibold flex-shrink-0">${e.avatar}</div><div class="flex-1 min-w-0"><div class="flex items-center justify-between mb-1"><h3 class="font-semibold text-gray-900 truncate">${e.name}</h3><span class="text-xs text-gray-500 flex-shrink-0">${e.time}</span></div><div class="flex items-center justify-between gap-2"><p class="text-sm text-gray-600 truncate flex-1">${e.lastMessage}</p><div class="flex items-center gap-2 flex-shrink-0"><span class="text-xs text-gray-500">${e.members} members</span>${e.unread>0?`<span class="gradient-bg text-white text-xs font-semibold px-2 py-0.5 rounded-full min-w-[20px] text-center">${e.unread}</span>`:""}</div></div></div></div>`).join(""))}function initProfile(){initDarkMode(),applyDarkMode()}function applyDarkMode(){"true"===localStorage.getItem("darkMode")&&document.body.classList.add("dark")}const style=document.createElement("style");style.textContent=".animate-fade-in { animation: fadeIn 0.3s ease-in-out; } @keyframes fadeIn { from { opacity: 0; transform: translate(-50%, -20px); } to { opacity: 1; transform: translate(-50%, 0); } }",document.head.appendChild(style);
